
import os
import subprocess
import time


os.environ["TORCH_HOME"] = "/cache"
os.environ["HF_ENDPOINT"] = "https://hf-mirror.com"


INPUT_DIR = "/new_data"
OUTPUT_BASE_DIR = "/results"
EXECUTION_DIR = ""  


MODELS = [
    "resnet18",
    "resnet101", "resnext50_32x4d",
    "densenet121", "vit_base_patch16_224",
    "pit_b_224", "visformer_small", "swin_tiny_patch4_window7_224"
]


ATTACKS = ['cwt']



with open("attack_model_times.txt", "a") as time_file:
    for attack in ATTACKS:
        for model in MODELS:
            output_dir = os.path.join(OUTPUT_BASE_DIR, attack, model)
            os.makedirs(output_dir, exist_ok=True)

            start_time = time.time()

            print(f"Running attack: {attack}, model: {model}")
            subprocess.run([
                "python", "main.py",
                "--input_dir", INPUT_DIR,
                "--output_dir", output_dir,
                "--attack", attack,
                "--model", model,
                '--batchsize', '10',
                '--range_max', '1.3',
                '--num_block', '2',
                '--num_scale', '20',
                '--rotation_probability','0.5',
                '--max_angle','26',
            ], cwd=EXECUTION_DIR)

            end_time = time.time()
            elapsed_time = end_time - start_time

            time_file.write(f"Attack: {attack}, Model: {model} completed in {elapsed_time:.2f} seconds\n")
            print(f"Attack: {attack}, Model: {model} completed in {elapsed_time:.2f} seconds")

            print(f"Evaluating model: {model} for attack: {attack}")
            subprocess.run([
                "python", "main.py",
                "--input_dir", INPUT_DIR,
                "--output_dir", output_dir,
                "--eval"
            ], cwd=EXECUTION_DIR)
